## লক্ষ্য
A-to-Z একটি বাস্তব ক্যাসিনো গেমিং সাইট: ইউজার অথ, রোল/পারমিশন, ওয়ালেট, ডিপোজিট/উইথড্র, রেফার/কমিশন, এজেন্ট ম্যানেজমেন্ট, গেম ক্যাটালগ/ফিল্টার/প্লে, অ্যাডমিন প্যানেল, সিকিউরিটি, লগিং, টেস্টিং—সবকিছু ধাপে ধাপে ইমপ্লিমেন্ট।

## প্রধান ফিচারসমূহ
- ইউজার: রেজিস্ট্রেশন/লগইন, পাসওয়ার্ড রিসেট, প্রোফাইল/KYC
- RBAC: রোল (admin, agent, player), পারমিশন, পলিসি
- ওয়ালেট: ব্যালেন্স, লেডজার, ট্রানজ্যাকশন (credit/debit), ফ্রড-চেক
- পেমেন্ট: ডিপোজিট/উইথড্র—গেটওয়ে অ্যাডাপ্টার (ম্যানুয়াল/অনলাইন দুটো সাপোর্ট)
- রেফার: রেফার কোড, টায়ারড কমিশন, পেআউট লজিক
- এজেন্ট: সাব-এজেন্ট, রেট/ক্যাপ, রেভেনিউ রিপোর্ট
- গেম: হোমপেজ ক্যাটালগ, ক্যাটেগরি ফিল্টার, সার্চ, ফেভারিটস
- প্লে: গেম লঞ্চ/সেশন, ব্যালেন্স চেক, ডেবিট/ক্রেডিট, রোলব্যাক
- কলব্যাক/ওয়েবহুক: প্রোভাইডার থেকে ট্রানজ্যাকশন ইভেন্ট, সিগনেচার/IP যাচাই, আইডেমপোটেন্সি
- অ্যাডমিন: ড্যাশবোর্ড, ইউজার/এজেন্ট/গেম/ফিন্যান্স রিপোর্ট, কনফিগ
- লগিং/অবজারভেবিলিটি: স্ট্রাকচার্ড লগ, অডিট ট্রেইল
- টেস্টিং: ফিচার/ইন্টেগ্রেশন/কন্ট্র্যাক্ট টেস্ট, সিড ডেটা

## টেকনিক্যাল আর্কিটেকচার
- ব্যাকএন্ড: Laravel 12, সার্ভিস লেয়ার, রিপোজিটরি প্যাটার্ন
- ফ্রন্টএন্ড: Blade/Tailwind ভিত্তিক UI (প্রয়োজনে SPA পরবর্তীতে)
- ডাটাবেস: MySQL (ওয়ালেট/ট্রানজ্যাকশন কনসিসটেন্সি), Redis (ক্যাশ/কিউ)
- ইন্টেগ্রেশন: `https://pre-api.agsoftgames.com`—আগেই প্রাথমিক ক্লায়েন্ট তৈরি, `agsoftgames` প্রোভাইডার কী সাপোর্ট
- সিকিউরিটি: HTTPS, HMAC সিগনেচার, CSRF, রেট-লিমিটিং, IP allowlist

## ডাটা মডেল (মূল টেবিল)
- users, roles, permissions, role_user, permission_role
- agents, agent_commissions, referrals, referral_commissions
- wallets, wallet_ledgers, payment_requests, withdrawals
- game_providers, games (ক্যাটালগ), game_categories, game_sessions, game_transactions
- callback_events, audit_logs

## API/রাউটিং
### প্লেয়ার ফেসিং
- `POST /register`, `POST /login`, `POST /password/forgot`, `POST /password/reset`
- `GET /wallet/balance`, `POST /wallet/deposit`, `POST /wallet/withdraw`
- `GET /games` (পেজিনেশন/ফিল্টার), `GET /games/{id}`
- `POST /games/{provider}/launch`, `GET /games/{provider}/balance`
- `POST /games/{provider}/debit|credit|rollback`
### প্রোভাইডার কলব্যাক
- `POST /api/games/{provider}/callback` (সিগনেচার/IP যাচাই, আইডেমপোটেন্সি)
### অ্যাডমিন
- `GET /admin/dashboard`, ইউজার/এজেন্ট/ফাইন্যান্স/গেম ম্যানেজমেন্ট CRUD

## UI পেজসমূহ
- হোম: ক্যাটালগ, ক্যাটেগরি ফিল্টার, সার্চ, ট্যাগস
- গেম ডিটেইল: স্ক্রিনশট, RTP/ফিচার, Play বাটন
- অথ: লগইন/রেজিস্টার/ফরগট/রিসেট
- ওয়ালেট: ব্যালেন্স/হিস্টরি/ডিপোজিট/উইথড্র
- রেফার: কোড, আর্নিংস, শেয়ার
- এজেন্ট: ড্যাশবোর্ড, সাব-এজেন্ট, কমিশন
- অ্যাডমিন: রিপোর্ট/কনফিগ

## গেম ইন্টেগ্রেশন ফ্লো
1. ইউজার Play চাপলে: `launch` → সেশন তৈরি → প্রোভাইডার URL/টোকেন রিটার্ন
2. গেম প্লে চলাকালে: প্রোভাইডার `balance`/`debit`/`credit`/`rollback` API ব্যবহার
3. প্রোভাইডার ওয়েবহুক: `callback` এ ইভেন্ট আসে → সিগনেচার/IP যাচাই → ট্রানজ্যাকশন আপডেট → ওয়ালেট ব্যালেন্স আপডেট → আইডেমপোটেন্ট

## পেমেন্ট ফ্লো
- ডিপোজিট: পেমেন্ট গেটওয়ে → ওয়ালেট ক্রেডিট → লেডজার রেকর্ড
- উইথড্র: কিউড রিকোয়েস্ট → রিভিউ/KYC → প্রসেসড পেআউট → ওয়ালেট ডেবিট
- গেটওয়ে অ্যাডাপ্টার ইন্টারফেস: `GatewayInterface` (bkash/nagad/stripe/paypal ইত্যাদি প্লাগযোগ্য)

## রেফার/এজেন্ট কমিশন
- রেফারাল ট্র্যাকিং: `referral_code` → প্রথম রেজিস্ট্রেশন/ডিপোজিট
- কমিশন ক্যাল্ক: ডিপোজিট/ওয়েজারের উপর টায়ারড রেট
- এজেন্ট: সাব-এজেন্ট, কনফিগারেবল রেট, রিপোর্টিং, পেআউট

## RBAC
- প্যাকেজ বা কাস্টম: roles/permissions টেবিল
- Middleware/Policy দিয়ে রুট/অ্যাকশন গার্ড

## সিকিউরিটি ও কমপ্লায়েন্স
- HTTPS বাধ্যতামূলক
- ইনপুট ভ্যালিডেশন, রেট-লিমিট
- অডিট লগ, সংবেদনশীল ডেটা এনক্রিপ্ট
- KYC/AML স্টেপস (ডক আপলোড/ভেরিফিকেশন)

## টেস্টিং
- ফিচার টেস্ট: অথ/ওয়ালেট/কলব্যাক/আইডেমপোটেন্সি
- কন্ট্র্যাক্ট টেস্ট: প্রোভাইডার API JSON স্কিমা
- সিডার: ডেমো ইউজার/গেম/ওয়ালেট

## ডেভঅপস
- এনভায়রনমেন্ট ভ্যারিয়েবল: `GAMES_*`, গেটওয়ে ক্রেডেনশিয়ালস
- কিউ: Redis/Database
- ক্যাশ: Redis
- লগিং: `games` চ্যানেল + অডিট লগ

## ডেলিভারেবলস (ফেজভিত্তিক)
- Phase 1: Auth, RBAC, Wallet, Game Catalog UI
- Phase 2: Provider Launch/Play flow, Callback idempotency, Reporting
- Phase 3: Deposit/Withdraw Gateways, Referral/Agent, Admin Panel
- Phase 4: KYC/AML, Security hardening, Full test coverage

## অ্যাকসেপটেন্স ক্রাইটেরিয়া
- গেম ক্যাটালগ দেখা ও ক্যাটেগরি ফিল্টার কাজ করে
- Play → সেশন/লঞ্চ সফল, ব্যালেন্স/ডেবিট/ক্রেডিট কাজ করে
- Callback → সিগনেচার/IP যাচাই ও আইডেমপোটেন্ট প্রসেসিং
- Auth/RBAC → রোল অনুসারে অ্যাক্সেস নিয়ন্ত্রণ
- Wallet → ট্রানজ্যাকশন কনসিসটেন্ট, লেডজার রেকর্ড
- Referral/Agent → কমিশন ক্যাল্ক ও রিপোর্টিং

আপনি কনফার্ম করলে, আমি Phase 1 থেকে ইমপ্লিমেন্টেশন শুরু করবো—Auth/RBAC/Wallet/গেম ক্যাটালগ UI, এরপর ধাপে ধাপে বাকি অংশগুলো সম্পন্ন করবো।